/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.renderers.notebook;

import com.ibm.hwmca.fw.servlet.renderers.notebook.CustomWNotebook;
import com.ibm.ps.wcl.components.notebook.WNotebook;
import com.ibm.ps.wcl.components.notebook.WNotebookComponent;
import com.ibm.ps.wcl.components.notebook.WNotebookPage;
import com.ibm.ps.wcl.core.RenderingContext;
import com.ibm.ps.wcl.core.WComponent;
import com.ibm.ps.wcl.core.form.AWInputComponent;
import com.ibm.ps.wcl.core.form.WButton;
import com.ibm.ps.wcl.core.form.WForm;
import com.ibm.ps.wcl.core.renderer.RendererException;
import com.ibm.ps.wcl.core.renderer.output.IOutput;
import com.ibm.ps.wcl.core.renderer.output.html.HTMLDocumentFragmentWrapper;
import com.ibm.ps.wcl.core.renderer.output.html.IHTMLDocumentFragmentOutput;
import com.ibm.ps.wcl.renderers.notebook.html.HTMLNotebookComponentRenderer;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLDivElement;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLImageElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class CustomHTMLNotebookComponentRenderer
extends HTMLNotebookComponentRenderer {
    public IOutput render(RenderingContext rc, Object renderObject) throws RendererException {
        HTMLDocumentFragmentWrapper doc;
        IOutput io = null;
        if (renderObject instanceof WNotebookComponent) {
            WNotebookComponent NBComp = (WNotebookComponent)renderObject;
            doc = rc.getDocumentFactory().createHTMLDocumentFragmentWrapper();
            switch (NBComp.getType()) {
                case 1: {
                    doc.appendToContentFragment((Node)this.createNotebookTabs(rc, doc, NBComp));
                    break;
                }
                case 2: {
                    doc.appendToContentFragment((Node)this.createNotebookPage(rc, doc, NBComp));
                    break;
                }
                case 3: {
                    doc.appendToContentFragment((Node)this.createNotebookButtons(rc, doc, NBComp));
                }
            }
        } else {
            throw new RendererException("Render object is not a WNotebookComponent.");
        }
        io = doc.createOutput(rc);
        return io;
    }

    protected HTMLElement createNotebookTabs(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WNotebookComponent nbComp) throws RendererException {
        HTMLTableElement table = null;
        HTMLTableRowElement tr = null;
        HTMLTableCellElement td = null;
        Object anchor = null;
        HTMLSelectElement select = null;
        int i = 0;
        WNotebook notebook = nbComp.getNotebook();
        if (notebook instanceof CustomWNotebook) {
            CustomWNotebook customWNotebook = (CustomWNotebook)notebook;
            int tabDirection = customWNotebook.getTabDirection();
            if (tabDirection == 2 || tabDirection == 3) {
                table = doc.createTABLEElement();
                table.setBorder("0");
                table.setWidth("25%");
                table.setCellPadding("0");
                table.setCellSpacing("0");
                if (!notebook.isFeatureEnabled(2)) {
                    ResourceBundle rb = ResourceBundle.getBundle("com.ibm.ps.wcl.nls.WclInternalResources", rc.getLocale());
                    WButton tabButton = (WButton)nbComp.getContainer();
                    tr = doc.createTRElement();
                    td = doc.createTDElement();
                    select = doc.createSELECTElement();
                    select.setName(rc.encodeName(notebook.makeUnique("tabs")));
                    td.setColSpan(2);
                    td.appendChild(select);
                    td.appendChild(doc.createMarkupTextNode("&nbsp;"));
                    tabButton.setText(rb.getString("TEXT_NOTEBOOK_GO_BUTTON"));
                    ((IHTMLDocumentFragmentOutput)tabButton.getOutput(rc)).appendContentFragment((Node)td);
                    td.appendChild(doc.createBRElement());
                    td.appendChild(doc.createMarkupTextNode("&nbsp;"));
                    tr.appendChild(td);
                    table.appendChild(tr);
                    table.setCellPadding("3");
                }
                tr = doc.createTRElement();
                Enumeration e = notebook.getPages();
                while (e.hasMoreElements()) {
                    WNotebookPage page = (WNotebookPage)e.nextElement();
                    td = doc.createTDElement();
                    td.setNoWrap(true);
                    td.setTitle(page.getDescription());
                    td.appendChild(this.createNBTab(rc, doc, notebook, page, i, select));
                    tr.appendChild(td);
                    ++i;
                }
                table.appendChild(tr);
            } else {
                table = doc.createTABLEElement();
                table.setBorder("0");
                table.setWidth("100%");
                table.setCellPadding("0");
                table.setCellSpacing("0");
                if (!notebook.isFeatureEnabled(2)) {
                    ResourceBundle rb = ResourceBundle.getBundle("com.ibm.ps.wcl.nls.WclInternalResources", rc.getLocale());
                    WButton tabButton = (WButton)nbComp.getContainer();
                    tr = doc.createTRElement();
                    td = doc.createTDElement();
                    select = doc.createSELECTElement();
                    select.setName(rc.encodeName(notebook.makeUnique("tabs")));
                    td.setColSpan(2);
                    td.appendChild(select);
                    td.appendChild(doc.createMarkupTextNode("&nbsp;"));
                    tabButton.setText(rb.getString("TEXT_NOTEBOOK_GO_BUTTON"));
                    ((IHTMLDocumentFragmentOutput)tabButton.getOutput(rc)).appendContentFragment((Node)td);
                    td.appendChild(doc.createBRElement());
                    td.appendChild(doc.createMarkupTextNode("&nbsp;"));
                    tr.appendChild(td);
                    table.appendChild(tr);
                    table.setCellPadding("3");
                }
                Enumeration e = notebook.getPages();
                while (e.hasMoreElements()) {
                    WNotebookPage page = (WNotebookPage)e.nextElement();
                    tr = doc.createTRElement();
                    td = doc.createTDElement();
                    if (page.hasStyle(1)) {
                        td.setColSpan(2);
                    } else {
                        td.setWidth(String.valueOf(10));
                        tr.appendChild(td);
                        td = doc.createTDElement();
                    }
                    td.setNoWrap(true);
                    td.setTitle(page.getDescription());
                    td.appendChild(this.createNBTab(rc, doc, notebook, page, i, select));
                    tr.appendChild(td);
                    table.appendChild(tr);
                    ++i;
                }
                tr = doc.createTRElement();
                td = doc.createTDElement();
                td.appendChild(doc.createMarkupTextNode("&nbsp;"));
                tr.appendChild(td);
                table.appendChild(tr);
            }
        } else {
            table = doc.createTABLEElement();
            table.setBorder("0");
            table.setWidth("100%");
            table.setCellPadding("0");
            table.setCellSpacing("0");
            if (!notebook.isFeatureEnabled(2)) {
                ResourceBundle rb = ResourceBundle.getBundle("com.ibm.ps.wcl.nls.WclInternalResources", rc.getLocale());
                WButton tabButton = (WButton)nbComp.getContainer();
                tr = doc.createTRElement();
                td = doc.createTDElement();
                select = doc.createSELECTElement();
                select.setName(rc.encodeName(notebook.makeUnique("tabs")));
                td.setColSpan(2);
                td.appendChild(select);
                td.appendChild(doc.createMarkupTextNode("&nbsp;"));
                tabButton.setText(rb.getString("TEXT_NOTEBOOK_GO_BUTTON"));
                ((IHTMLDocumentFragmentOutput)tabButton.getOutput(rc)).appendContentFragment((Node)td);
                td.appendChild(doc.createBRElement());
                td.appendChild(doc.createMarkupTextNode("&nbsp;"));
                tr.appendChild(td);
                table.appendChild(tr);
                table.setCellPadding("3");
            }
            Enumeration e = notebook.getPages();
            while (e.hasMoreElements()) {
                WNotebookPage page = (WNotebookPage)e.nextElement();
                tr = doc.createTRElement();
                td = doc.createTDElement();
                if (page.hasStyle(1)) {
                    td.setColSpan(2);
                } else {
                    td.setWidth(String.valueOf(10));
                    tr.appendChild(td);
                    td = doc.createTDElement();
                }
                td.setNoWrap(true);
                td.setTitle(page.getDescription());
                td.appendChild(this.createNBTab(rc, doc, notebook, page, i, select));
                tr.appendChild(td);
                table.appendChild(tr);
                ++i;
            }
            tr = doc.createTRElement();
            td = doc.createTDElement();
            td.appendChild(doc.createMarkupTextNode("&nbsp;"));
            tr.appendChild(td);
            table.appendChild(tr);
        }
        return table;
    }

    protected HTMLElement createNotebookPage(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WNotebookComponent nbComp) throws RendererException {
        HTMLDivElement div = doc.createDIVElement();
        IOutput o = nbComp.getContainer().getOutput(rc);
        ((IHTMLDocumentFragmentOutput)o).appendContentFragment((Node)div);
        ((IHTMLDocumentFragmentOutput)o).appendHeadFragment((Node)doc.getHeadFragment());
        return div;
    }

    protected HTMLElement createNotebookButtons(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WNotebookComponent nbComp) throws RendererException {
        HTMLDivElement div = doc.createDIVElement();
        IOutput o = nbComp.getContainer().getOutput(rc);
        ((IHTMLDocumentFragmentOutput)o).appendContentFragment((Node)div);
        ((IHTMLDocumentFragmentOutput)o).appendHeadFragment((Node)doc.getHeadFragment());
        this.renderCssStyles(rc, (WComponent)nbComp.getNotebook(), div, "wclNotebookButtons");
        return div;
    }

    private HTMLElement createNBTab(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WNotebook notebook, WNotebookPage page, int index, HTMLSelectElement select) throws RendererException {
        HTMLDivElement div = doc.createDIVElement();
        HTMLImageElement image = doc.createIMGElement();
        HTMLElement tab = null;
        String action = "turnPage(" + index + ")";
        boolean current = index == notebook.getCurrentPageIndex();
        ResourceBundle rb = ResourceBundle.getBundle("com.ibm.ps.wcl.nls.WclInternalResources", rc.getLocale());
        if (page.hasError()) {
            image.setSrc(this.getImageValue(rc, (WComponent)notebook, "IMG_STATUS_ERROR"));
            image.setAlt(rb.getString("ALT_TAG_ERROR_STATUS"));
        } else if (page.isRequired()) {
            image.setSrc(this.getImageValue(rc, (WComponent)notebook, "IMG_STATUS_REQUIRED"));
            image.setAlt(rb.getString("ALT_TAG_REQUIRED_STATUS"));
        } else {
            image.setSrc(this.getImageValue(rc, (WComponent)notebook, "IMG_BLANK"));
            image.setAlt(" ");
            image.setWidth("8");
        }
        if (select != null) {
            HTMLOptionElement option = doc.createOPTIONElement();
            option.appendChild(doc.createTextNode(page.getTabText()));
            option.setValue(action);
            option.setSelected(current);
            select.appendChild(option);
            tab = doc.createSPANElement();
        } else {
            tab = this.createAnchorTag(rc, doc, notebook, action);
            tab.setAttribute("accessKey", page.getAccessKey());
        }
        tab.appendChild(doc.createTextNode(page.getTabText()));
        div.appendChild(image);
        div.appendChild(tab);
        if (select == null) {
            this.renderCssStyles(rc, (WComponent)notebook, div, current ? "wclNotebookSelectedTabCell" : "wclNotebookUnselectedTabCell");
        }
        this.renderCssStyles(rc, (WComponent)notebook, tab, current ? "wclNotebookSelectedTab" : "wclNotebookUnselectedTab");
        return div;
    }

    private HTMLAnchorElement createAnchorTag(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WNotebook notebook, String action) throws RendererException {
        HTMLAnchorElement anchor = doc.createAElement();
        AWInputComponent actionComp = notebook.getInputComponent("action");
        WForm form = AWInputComponent.findWForm((WComponent)actionComp);
        anchor.setHref("#");
        if (notebook.isFeatureEnabled(2)) {
            if (notebook.isAnchoring()) {
                anchor.setAttribute("onClick", "return doNotebookSubmit('" + rc.encodeName(form.getName()) + "', '" + actionComp.getName() + "', '" + action + "', '" + rc.encodeName(actionComp.getName()) + "', '" + rc.encodeName("wclhidden") + "', '" + rc.encodeName("wclanchor") + "');");
            } else {
                anchor.setAttribute("onClick", "return doNotebookSubmit('" + rc.encodeName(form.getName()) + "', '" + actionComp.getName() + "', '" + action + "', '" + rc.encodeName(actionComp.getName()) + "', '" + rc.encodeName("wclhidden") + "', null);");
            }
        }
        return anchor;
    }
}

